// USound.cp
// USound.h
// ----------------------------------------------------------------------------------
// Sound translator for the Spelling Checker.
//
// Note: This file is proprietary and confidential to Art Pollard
//	and Lextek Internation.  
// Copyright 1994 Art Pollard / LexTek International
//
// This translates a sound into a spell for a prefix.  It is passed a 'sound' 
// represented by a number.  IT then returns a prefix for the word with that
// sound.
// 
// ----------------------------------------------------------------------------------
// History:
// 		Art Pollard			June 94
//			Original.  Simple read/write functions.
//		Clark Goble			08/11/94
//			Made the buffer into an abstract C++ class that was basically
//			an abstract datafile class.
// ----------------------------------------------------------------------------------

#ifndef _USOUND_
#define _USOUND_


#define Initial_B         (1)
#define Initial_CH        (2)
#define Initial_CHORK     (3)
#define Initial_CHORKORSH (4)
#define Initial_CHORZ     (5)
#define Initial_TSORZ     (6)
#define Initial_JORG      (12) /* same as J */
#define Initial_D         (8)
#define Initial_F         (9)
#define Initial_G         (10)
#define Initial_H         (11)
#define Initial_J         (12)
#define Initial_K         (13)
#define Initial_L         (14)
#define Initial_M         (15)
#define Initial_N         (16)
#define Initial_P         (17)
#define Initial_R         (18)
#define Initial_S         (19)
#define Initial_SH        (20)
#define Initial_T         (21)
#define Initial_TS        (22)
#define Initial_V         (23)
#define Initial_W         (24)
#define Initial_Z         (25)
#define Initial_VOWEL     (26)


typedef struct {
	char *WordPrefix;
	char Length;
} HeadStart;

class USound {
public:	
	USound();
	~USound();
	
	void  Reset();
	char *Start(short Prefix,short *Length);
	char *NextPhoneme(short *Length);
private:	
	short Position;
	HeadStart *CurrentRuleSet;
	
	HeadStart *B;
	HeadStart *CH;
	HeadStart *CHORKORSH;
	HeadStart *CHORZ;
	HeadStart *TSORZ;
	HeadStart *D;
	HeadStart *F;
	HeadStart *G;
	HeadStart *H;
	HeadStart *J;
	HeadStart *K;
	HeadStart *L;
	HeadStart *M;
	HeadStart *N;
	HeadStart *P;
	HeadStart *R;
	HeadStart *S;
	HeadStart *SH;
	HeadStart *T;
	HeadStart *TS;
	HeadStart *V;
	HeadStart *W;
	HeadStart *Z;
	HeadStart *VOWEL;
	HeadStart *CHORK;
	HeadStart *JORG;
}; // USound

#endif

